#include "JobQueue.h"

namespace Upp {

#define LLOG(x)  RLOG(x)

bool JobQueue::Execute()
{
 	while(Do())
 		;
	return IsSuccess();
}

void JobQueue::CleanUp()
{
	if(!queue.IsEmpty()) {
		queue.Clear();
	}
	if(IsCleanup() || !WhenHalt) {
		start_time = 0;
		state = FAILURE;
	}
	else {
		start_time = msecs();
		state = CLEANUP;
		WhenHalt();
	}
}

void JobQueue::Halt(int rc, const char* reason)
{
	state = FAILURE;
	error_code = rc;
	error_desc = reason;
	start_time = 0;
	throw Exc("Queue halted.");
}

bool JobQueue::IsTimeout() const
{
	return timeout > 0 && timeout <= msecs(start_time);
}

bool JobQueue::Do()
{
	try {
		while(!start_time) {
			start_time = msecs();
			error_code = 0;
			error_desc = Null;
			state = INPROGRESS;
		}
		if(!queue.IsEmpty()) {
			if(IsTimeout()) {
				if(IsCleanup()) throw Exc(""); 
				else Halt(t_("Operation timed out."));
			}
			if(!GetJob()()) NextJob();
			WhenDo();
		}
		if(queue.IsEmpty()) {
			start_time = 0;
			state = IsCleanup()
				? FAILURE
				: SUCCESS;
		}
	}
	catch(Exc e) { 	CleanUp();	}
	return InProgress();
}

JobQueue::JobQueue()
: start_time(0),
  timeout(0),
  error_code(0),
  state(FAILURE)
{
}
}

